/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.base.VWString;
import java.net.MalformedURLException;
import java.net.URI;

public class VWCORBANameURL {
    private static final long serialVersionUID = 464L;
    private String host;
    private int port = 32780;
    private int region = -1;
    private String m_fullName;
    private boolean m_isIOR;
    private static final VWString vws_invalidCorbaUri = new VWString("vw.base.invalidCorbaUri", "{0} is not a valid corba URI ({corba,ior}://host:portNo/regionNumber.)");
    private static final VWString vws_invalidRegion = new VWString("vw.base.invalidRegion", "{0} is not a valid corba URI. Region number needs to be positive integer. ({corba,ior}://host:portNo/regionNumber.)");
    private static final VWString vws_invalidHostOrPort = new VWString("vw.base.invalidHostOrPort", "{0} is not a valid corba URI. Invalid host or port was specified. ({corba,ior}://host:portNo/regionNumber.)");

    public static String _get_FILE_DATE() {
        return "$Date:   17 Mar 2006 09:34:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public int getRegion() {
        return this.region;
    }

    public boolean isIOR() {
        return this.m_isIOR;
    }

    private void formFullName() {
        this.m_fullName = (this.m_isIOR ? "ior" : "corba") + "://" + this.host + ":" + this.port + "/" + this.region;
    }

    public VWCORBANameURL(String host, int port, int region, boolean isIOR) {
        this.host = host;
        this.port = port;
        this.region = region;
        this.m_isIOR = isIOR;
        this.formFullName();
    }

    public VWCORBANameURL(String url) throws MalformedURLException {
        URI m_uri;
        try {
            m_uri = new URI(url);
        }
        catch (Exception e) {
            throw new MalformedURLException(url);
        }
        String scheme = m_uri.getScheme();
        if (scheme == null) {
            throw new MalformedURLException(url);
        }
        this.m_isIOR = scheme.equals("ior");
        boolean isCorba = scheme.equals("corba");
        if (!isCorba && !this.m_isIOR) {
            throw new MalformedURLException(vws_invalidCorbaUri.toString(url));
        }
        this.host = m_uri.getHost();
        int iport = m_uri.getPort();
        if (iport > 0) {
            this.port = iport;
        }
        try {
            this.region = Integer.parseInt(m_uri.getPath().substring(1));
        }
        catch (Exception e) {
            throw new MalformedURLException(vws_invalidRegion.toString(url));
        }
        if (this.host == null || this.port == -1 || this.region == -1) {
            throw new MalformedURLException(vws_invalidHostOrPort.toString(url));
        }
        this.formFullName();
    }

    public String toString() {
        return this.m_fullName;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"corba://myHost:222/1", "corba://myHost:-1/0034", "corba://myHost/00234", "corba://myHost:5000/123", "corba://myHost:0009/abc"};
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                VWCORBANameURL r = new VWCORBANameURL(args[i]);
                System.out.println(i + ":" + args[i] + "=" + r.toString());
            }
            catch (Exception e) {
                System.out.println(i + ":" + args[i] + " EXCEPTION!");
                e.printStackTrace();
            }
            System.out.println("----------");
        }
    }
}

